/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWExpressionTextField;
import filenet.vw.toolkit.design.property.VWTime;
import filenet.vw.toolkit.design.property.event.IVWExpressionTextFieldListener;
import filenet.vw.toolkit.design.property.event.VWExpressionTextFieldEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.utils.IVWPropertyData;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskField;
import filenet.vw.toolkit.utils.uicontrols.textfield.VWMaskMacros;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class VWStepDeadlinePanel
extends JPanel
implements IVWPropertyTab,
ActionListener,
DocumentListener,
IVWExpressionTextFieldListener {
    private VWMaskMacros m_macros = null;
    private JRadioButton m_deadlineLiteralType = null;
    private VWMaskField m_deadlineTextField = null;
    private JComboBox m_deadlineUnitCBox = null;
    private JRadioButton m_deadlineExpType = null;
    private VWExpressionTextField m_deadlineExpTextField = null;
    private JLabel m_deadlineExpUnitsLabel = null;
    private VWMaskField m_reminderTextField = null;
    private JComboBox m_reminderUnitCBox = null;
    private VWStepDefinition m_stepDefinition = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWLabelListCellRenderer m_customComboBoxRenderer = new VWLabelListCellRenderer();

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_macros = new VWMaskMacros();
            this.m_macros.addMacro('#', "[0-9]");
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 40);
            this.add((Component)this.getDeadlinePanel(), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.getReminderPanel(), gbCons);
            this.setSelectedStep(vwMapNode);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setSelectedStep(VWMapNode vwMapNode) {
        String deadline = "0";
        long reminder = 0L;
        try {
            if (this.m_stepDefinition != null && this.m_stepDefinition == vwMapNode) {
                return;
            }
            this.m_stepDefinition = (VWStepDefinition)vwMapNode;
            if (this.m_stepDefinition == null) {
                this.enableControls(false);
            } else if (this.m_stepDefinition.getStepId() == 0) {
                this.m_stepDefinition.setDeadline(0L);
                this.m_stepDefinition.setReminder(0L);
                this.enableControls(false);
            } else {
                deadline = this.m_stepDefinition.getDeadlineExpr();
                reminder = this.m_stepDefinition.getReminder();
                this.enableControls(true);
            }
            this.updateControls(deadline, reminder);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseReferences() {
        if (this.m_deadlineLiteralType != null) {
            this.m_deadlineLiteralType.removeActionListener(this);
            this.m_deadlineLiteralType = null;
        }
        if (this.m_deadlineTextField != null) {
            this.m_deadlineTextField.getDocument().removeDocumentListener(this);
            this.m_deadlineTextField = null;
        }
        if (this.m_deadlineUnitCBox != null) {
            this.m_deadlineUnitCBox.removeActionListener(this);
            this.m_deadlineUnitCBox = null;
        }
        if (this.m_deadlineExpType != null) {
            this.m_deadlineExpType.removeActionListener(this);
            this.m_deadlineExpType = null;
        }
        if (this.m_deadlineExpTextField != null) {
            this.m_deadlineExpTextField.removeExpressionTextFieldListener(this);
            this.m_deadlineExpTextField = null;
        }
        this.m_deadlineExpUnitsLabel = null;
        if (this.m_reminderTextField != null) {
            this.m_reminderTextField.getDocument().removeDocumentListener(this);
            this.m_reminderTextField = null;
        }
        if (this.m_reminderUnitCBox != null) {
            this.m_reminderUnitCBox.removeActionListener(this);
            this.m_reminderUnitCBox = null;
        }
        this.m_macros = null;
        this.m_stepDefinition = null;
        this.m_authPropertyData = null;
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_deadlineUnitCBox) {
            this.updateDeadlineDefinition();
        } else if (src == this.m_reminderUnitCBox) {
            this.updateReminderDefinition();
        } else if (src == this.m_deadlineLiteralType) {
            this.performDeadlineLiteralTypeAction();
        } else if (src == this.m_deadlineExpType) {
            this.performDeadlineExpTypeAction();
        }
    }

    public void changedUpdate(DocumentEvent event) {
        this.insertUpdate(event);
    }

    public void insertUpdate(DocumentEvent event) {
        Document srcDoc = event.getDocument();
        if (srcDoc == this.m_deadlineTextField.getDocument()) {
            this.updateDeadlineDefinition();
        } else if (srcDoc == this.m_reminderTextField.getDocument()) {
            this.updateReminderDefinition();
        }
    }

    public void removeUpdate(DocumentEvent event) {
        this.insertUpdate(event);
    }

    public void textUpdated(VWExpressionTextFieldEvent event) {
        Object src = event.getSource();
        if (src == this.m_deadlineExpTextField) {
            this.updateExpDeadlineDefinition();
        }
    }

    private JPanel getDeadlinePanel() {
        try {
            JPanel deadlinePanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 0;
            gbCons.insets = new Insets(2, 2, 0, 0);
            deadlinePanel.add((Component)new JLabel(VWResource.s_deadlineWithin), gbCons);
            ++gbCons.gridy;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(0, 2, 0, 0);
            this.m_deadlineLiteralType = new JRadioButton();
            this.m_deadlineLiteralType.setSelected(true);
            this.m_deadlineLiteralType.addActionListener(this);
            deadlinePanel.add((Component)this.m_deadlineLiteralType, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 0.5;
            gbCons.insets = new Insets(2, 0, 0, 0);
            this.m_deadlineTextField = new VWMaskField("#####", this.m_macros, ' ');
            this.m_deadlineTextField.setName("m_deadlineTextField_VWStepDeadlinePanel");
            this.m_deadlineTextField.setColumns(30);
            this.m_deadlineTextField.getDocument().addDocumentListener(this);
            deadlinePanel.add((Component)this.m_deadlineTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(0, 5, 0, 0);
            this.m_deadlineUnitCBox = new JComboBox();
            this.m_deadlineUnitCBox.setName("m_deadlineUnitCBox_VWStepDeadlinePanel");
            this.m_deadlineUnitCBox.addItem(VWResource.s_minutes);
            this.m_deadlineUnitCBox.addItem(VWResource.s_hours);
            this.m_deadlineUnitCBox.addItem(VWResource.s_days);
            this.m_deadlineUnitCBox.addItem(VWResource.s_weeks);
            this.m_deadlineUnitCBox.setRenderer(this.m_customComboBoxRenderer);
            this.m_deadlineUnitCBox.addActionListener(this);
            deadlinePanel.add((Component)this.m_deadlineUnitCBox, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.insets = new Insets(5, 2, 0, 0);
            this.m_deadlineExpType = new JRadioButton();
            this.m_deadlineExpType.setSelected(false);
            this.m_deadlineExpType.addActionListener(this);
            deadlinePanel.add((Component)this.m_deadlineExpType, gbCons);
            ButtonGroup buttons = new ButtonGroup();
            buttons.add(this.m_deadlineLiteralType);
            buttons.add(this.m_deadlineExpType);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.insets = new Insets(5, 0, 0, 0);
            this.m_deadlineExpTextField = new VWExpressionTextField(this.m_authPropertyData.getMainContainer(), (IVWPropertyData)this.m_authPropertyData);
            this.m_deadlineExpTextField.setName("m_deadlineExpTextField_VWStepDeadlinePanel");
            this.m_deadlineExpTextField.setColumns(30);
            this.m_deadlineExpTextField.addExpressionTextFieldListener(this);
            this.m_deadlineExpTextField.setEnabled(false);
            deadlinePanel.add((Component)this.m_deadlineExpTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.insets = new Insets(5, 10, 0, 0);
            this.m_deadlineExpUnitsLabel = new JLabel(VWResource.s_minutes);
            this.m_deadlineExpUnitsLabel.setEnabled(false);
            deadlinePanel.add((Component)this.m_deadlineExpUnitsLabel, gbCons);
            return deadlinePanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private JPanel getReminderPanel() {
        try {
            JPanel reminderPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 2;
            gbCons.insets = new Insets(0, 0, 0, 0);
            reminderPanel.add((Component)new JLabel(VWResource.s_sendReminderBeforeDeadline), gbCons);
            ++gbCons.gridy;
            gbCons.weightx = 0.5;
            gbCons.anchor = 21;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(2, 0, 0, 5);
            this.m_reminderTextField = new VWMaskField("#####", this.m_macros, ' ');
            this.m_reminderTextField.setName("m_reminderTextField_VWStepDeadlinePanel");
            this.m_reminderTextField.setText("0");
            this.m_reminderTextField.getDocument().addDocumentListener(this);
            reminderPanel.add((Component)this.m_reminderTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_reminderUnitCBox = new JComboBox();
            this.m_reminderUnitCBox.setName("m_reminderUnitCBox_VWStepDeadlinePanel");
            this.m_reminderUnitCBox.addItem(VWResource.s_minutes);
            this.m_reminderUnitCBox.addItem(VWResource.s_hours);
            this.m_reminderUnitCBox.addItem(VWResource.s_days);
            this.m_reminderUnitCBox.addItem(VWResource.s_weeks);
            this.m_reminderUnitCBox.setRenderer(this.m_customComboBoxRenderer);
            this.m_reminderUnitCBox.addActionListener(this);
            reminderPanel.add((Component)this.m_reminderUnitCBox, gbCons);
            ++gbCons.gridy;
            gbCons.fill = 3;
            gbCons.weighty = 1.0;
            reminderPanel.add((Component)new JLabel(" "), gbCons);
            return reminderPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void enableControls(boolean bEnable) {
        try {
            this.m_deadlineUnitCBox.setEnabled(bEnable);
            this.m_deadlineTextField.setEnabled(bEnable);
            this.m_reminderTextField.setEnabled(bEnable);
            this.m_reminderUnitCBox.setEnabled(bEnable);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateControls(String deadline, long reminder) {
        try {
            if (deadline == null || deadline.length() == 0) {
                deadline = "0";
            }
            try {
                long deadlineValue = Long.parseLong(deadline);
                this.updateDeadlineControls(deadlineValue);
            }
            catch (Exception ex) {
                this.updateDeadlineExpControls(deadline);
            }
            this.updateReminderControls(reminder);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateReminderControls(long reminder) {
        try {
            VWTime reminderTime = new VWTime(reminder, 0);
            if (reminder != 0L) {
                if (!(reminderTime.convertTime(3) || reminderTime.convertTime(2) || reminderTime.convertTime(1))) {
                    reminderTime.convertTime(0);
                }
            } else {
                reminderTime.convertTime(0);
            }
            this.m_reminderTextField.getDocument().removeDocumentListener(this);
            this.m_reminderUnitCBox.removeActionListener(this);
            this.m_reminderTextField.setText(reminderTime.getTime() + "");
            this.m_reminderUnitCBox.setSelectedIndex(reminderTime.getUnit());
            this.m_reminderTextField.getDocument().addDocumentListener(this);
            this.m_reminderUnitCBox.addActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateDeadlineExpControls(String deadline) {
        try {
            this.m_deadlineTextField.getDocument().removeDocumentListener(this);
            this.m_deadlineUnitCBox.removeActionListener(this);
            this.m_deadlineExpTextField.removeExpressionTextFieldListener(this);
            this.m_deadlineExpType.setSelected(true);
            this.performDeadlineExpTypeAction();
            this.m_deadlineTextField.setText("");
            this.m_deadlineUnitCBox.setSelectedIndex(0);
            this.m_deadlineExpTextField.setText(deadline);
            this.m_deadlineTextField.getDocument().addDocumentListener(this);
            this.m_deadlineUnitCBox.addActionListener(this);
            this.m_deadlineExpTextField.addExpressionTextFieldListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateDeadlineControls(long deadline) {
        try {
            VWTime deadlineTime = new VWTime(deadline, 0);
            if (deadline != 0L) {
                if (!(deadlineTime.convertTime(3) || deadlineTime.convertTime(2) || deadlineTime.convertTime(1))) {
                    deadlineTime.convertTime(0);
                }
            } else {
                deadlineTime.convertTime(0);
            }
            this.m_deadlineTextField.getDocument().removeDocumentListener(this);
            this.m_deadlineUnitCBox.removeActionListener(this);
            this.m_deadlineExpTextField.removeExpressionTextFieldListener(this);
            this.m_deadlineLiteralType.setSelected(true);
            this.performDeadlineLiteralTypeAction();
            this.m_deadlineTextField.setText(deadlineTime.getTime() + "");
            this.m_deadlineUnitCBox.setSelectedIndex(deadlineTime.getUnit());
            this.m_deadlineExpTextField.setText("");
            this.m_deadlineTextField.getDocument().addDocumentListener(this);
            this.m_deadlineUnitCBox.addActionListener(this);
            this.m_deadlineExpTextField.addExpressionTextFieldListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateExpDeadlineDefinition() {
        try {
            String deadlineString = this.m_deadlineExpTextField.getText();
            if (deadlineString.length() == 0) {
                deadlineString = "0";
            }
            this.m_stepDefinition.setDeadlineExpr(deadlineString);
            this.m_authPropertyData.setDirty();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateDeadlineDefinition() {
        try {
            String deadlineString = this.m_deadlineTextField.getText();
            if (deadlineString.length() == 0) {
                deadlineString = "0";
            }
            Long deadline = new Long(deadlineString.trim());
            int deadlineUnit = this.m_deadlineUnitCBox.getSelectedIndex();
            VWTime timeDeadline = new VWTime(deadline, deadlineUnit);
            timeDeadline.convertTime(0);
            this.m_stepDefinition.setDeadline(timeDeadline.getTime());
            this.m_authPropertyData.setDirty();
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateReminderDefinition() {
        try {
            String reminderString = this.m_reminderTextField.getText();
            if (reminderString.length() == 0) {
                reminderString = "0";
            }
            Long reminder = new Long(reminderString.trim());
            int reminderUnit = this.m_reminderUnitCBox.getSelectedIndex();
            VWTime timeReminder = new VWTime(reminder, reminderUnit);
            timeReminder.convertTime(0);
            this.m_stepDefinition.setReminder(timeReminder.getTime());
            this.m_authPropertyData.setDirty();
        }
        catch (NumberFormatException ex) {
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performDeadlineLiteralTypeAction() {
        this.m_deadlineTextField.setEnabled(true);
        this.m_deadlineTextField.setText("0");
        this.m_deadlineUnitCBox.setEnabled(true);
        this.m_deadlineExpTextField.setEnabled(false);
        this.m_deadlineExpTextField.setText("");
        this.m_deadlineExpUnitsLabel.setEnabled(false);
    }

    private void performDeadlineExpTypeAction() {
        this.m_deadlineTextField.setEnabled(false);
        this.m_deadlineTextField.setText("");
        this.m_deadlineUnitCBox.setEnabled(false);
        this.m_deadlineExpTextField.setEnabled(true);
        this.m_deadlineExpTextField.setText("");
        this.m_deadlineExpUnitsLabel.setEnabled(true);
    }
}

